<?php $__env->startSection('styles'); ?>

    <!--  BEGIN CUSTOM STYLE FILE  -->
    <link rel="stylesheet" href="<?php echo e(asset('plugins/src/flatpickr/flatpickr.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/src/noUiSlider/nouislider.min.css')); ?>">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/light/plugins/flatpickr/custom-flatpickr.scss']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/dark/plugins/flatpickr/custom-flatpickr.scss']); ?>
    <!--  END CUSTOM STYLE FILE  -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div id="navSection" data-bs-spy="affix" class="nav  sidenav">
    <div class="sidenav-content">
        <a href="#basic" class="active nav-link">Basic</a>
        <a href="#date_time" class="nav-link">Date Time</a>
        <a href="#range_calendar" class="nav-link">Range Calendar</a>
        <a href="#preloading_time" class="nav-link">Preloading Time</a>
    </div>
</div>

<div class="row layout-top-spacing">

    <div id="basic" class="col-lg-12 col-12 layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">                                 
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Basic</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <p>Date time picker is powered by <span class="text-danger">flatpickr.js</span> that gives the ability to user to select date or time.</p>
                <div class="form-group mb-0">
                    <input id="basicFlatpickr" value="2022-09-04" class="form-control flatpickr flatpickr-input active" type="text" placeholder="Select Date..">
                </div>

                <div class="code-section-container show-code">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                        <pre>
var f1 = flatpickr(document.getElementById('basicFlatpickr'));
</pre>
                    </div>

                </div>

            </div>
        </div>
    </div>

    <div id="date_time" class="col-lg-12 col-12 layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">                                 
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Date Time</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <p>Use <code>enableTime: true</code> and <code>dateFormat: "Y-m-d H:i"</code> option to enable time support</p>
                <div class="form-group mb-0">
                    <input id="dateTimeFlatpickr" value="2022-09-19 12:00" class="form-control flatpickr flatpickr-input active" type="text" placeholder="Select Date..">
                </div>

                <div class="code-section-container">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                        <pre>
var f2 = flatpickr(document.getElementById('dateTimeFlatpickr'), {
enableTime: true,
dateFormat: "Y-m-d H:i",
});
</pre>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="range_calendar" class="col-lg-12 col-12 layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">                                 
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Range Calendar</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <p>Use <code>mode: range</code> select the date with range.</p>

                <div class="form-group mb-0">
                    <input id="rangeCalendarFlatpickr" class="form-control flatpickr flatpickr-input active" type="text" placeholder="Select Date..">
                </div>

                <div class="code-section-container">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                        <pre>
var f3 = flatpickr(document.getElementById('rangeCalendarFlatpickr'), {
mode: "range"
});
</pre>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div id="preloading_time" class="col-lg-12 col-12 layout-spacing">
        <div class="statbox widget box box-shadow">
            <div class="widget-header">                                 
                <div class="row">
                    <div class="col-xl-12 col-md-12 col-sm-12 col-12">
                        <h4>Preloading Time</h4> 
                    </div>
                </div>
            </div>
            <div class="widget-content widget-content-area">
                <p>Use <code>noCalendar: true</code> with Date Time options to disable calendar and show time picker only.</p>
                <div class="form-group mb-0">
                    <input id="timeFlatpickr" class="form-control flatpickr flatpickr-input active" type="text" placeholder="Select Date..">
                </div>

                <div class="code-section-container">
                            
                    <button class="btn toggle-code-snippet"><span>Code</span> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down toggle-code-icon"><polyline points="6 9 12 15 18 9"></polyline></svg></button>

                    <div class="code-section text-left">
                        <pre>
var f4 = flatpickr(document.getElementById('timeFlatpickr'), {
enableTime: true,
noCalendar: true,
dateFormat: "H:i",
defaultDate: "13:45"
});
</pre>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

    <script type="module" src="<?php echo e(asset('plugins/src/flatpickr/flatpickr.js')); ?>"></script>
    <script type="module" src="<?php echo e(asset('plugins/src/flatpickr/custom-flatpickr.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Work Station\cork-v3.9.0\laravel\vertical-light-menu\resources\views/admin/forms/date-time-picker.blade.php ENDPATH**/ ?>