<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>
        <?php if(isset($title)): ?>
            <?php if($title !== ''): ?>
                <?php echo e($title); ?> | Multipurpose Bootstrap Dashboard Template
            <?php else: ?>
                CORK Admin | Multipurpose Bootstrap Dashboard Template
            <?php endif; ?>
        <?php endif; ?>
    </title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(Vite::asset('resources/images/favicon.ico')); ?>"/>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/layouts/semi-dark-menu/light/loader.scss']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/layouts/semi-dark-menu/dark/loader.scss']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/layouts/semi-dark-menu/loader.js']); ?>

    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('plugins/src/bootstrap/css/bootstrap.min.css')); ?>">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/light/assets/main.scss']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/dark/assets/main.scss']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/light/plugins/perfect-scrollbar/perfect-scrollbar.scss']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/dark/plugins/perfect-scrollbar/perfect-scrollbar.scss']); ?>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/src/waves/waves.min.css')); ?>">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/layouts/semi-dark-menu/light/structure.scss']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/layouts/semi-dark-menu/dark/structure.scss']); ?>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/src/highlight/styles/monokai-sublime.css')); ?>">
    
    <style>
        body:not(.dark) .logo-light {
            display: block;
        }
        body:not(.dark) .logo-dark {
            display: none;
        }
        body.dark .logo-light {
            display: none;
        }
        body.dark .logo-dark {
            display: block;
        }
    </style>
   

    <?php if(isset($scrollspy)): ?>
        <?php if($scrollspy): ?>
            <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/light/assets/scrollspyNav.scss']); ?>
            <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/dark/assets/scrollspyNav.scss']); ?>
        <?php endif; ?>
    <?php endif; ?>
    <!-- END GLOBAL MANDATORY STYLES -->

    <!-- BEGIN PAGE LEVEL PLUGINS/CUSTOM STYLES -->
    <?php echo $__env->yieldContent('styles'); ?>
    <!-- END PAGE LEVEL PLUGINS/CUSTOM STYLES -->

</head>
<body class="
    <?php echo e(Request::routeIs('error404') ? 'error text-center' : ''); ?>

    <?php echo e(Request::routeIs('maintenance') ? 'maintanence text-center' : ''); ?>

    <?php echo e((Request::routeIs('boxedSignIn') || 
        Request::routeIs('boxedSignUp') || 
        Request::routeIs('boxedLockscreen') || 
        Request::routeIs('boxedPasswordReset') || 
        Request::routeIs('boxed2sv')) ? 'form' : ''); ?>


    <?php echo e((Request::routeIs('coverSignIn') || 
        Request::routeIs('coverSignUp') || 
        Request::routeIs('coverLockscreen') || 
        Request::routeIs('coverPasswordReset') || 
        Request::routeIs('cover2sv')) ? 'form' : ''); ?>

    <?php echo e(Request::routeIs('collapsed') ? 'alt-menu' : ''); ?>

    
    
" layout="<?php echo e(Request::routeIs('boxed') ? 'boxed' : ''); ?> boxed" >
    <!-- BEGIN LOADER -->
    <div id="load_screen"> <div class="loader"> <div class="loader-content">
        <div class="spinner-grow align-self-center"></div>
    </div></div></div>
    <!--  END LOADER -->
    
    <?php if(isset($simplePage)): ?>

        <?php if($simplePage): ?>

            <?php echo $__env->yieldContent('content'); ?>
            
        <?php else: ?>

        <?php if(!Request::routeIs('blank')): ?>
            <!--  BEGIN NAVBAR  -->
            <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!--  END NAVBAR  -->
        <?php endif; ?>

            <!--  BEGIN MAIN CONTAINER  -->
            <div class="main-container" id="container">

                <div class="overlay"></div>
                <div class="search-overlay"></div>

                <?php if(!Request::routeIs('blank')): ?>
                    <!--  BEGIN SIDEBAR  -->
                    <?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!--  END SIDEBAR  -->                    
                <?php endif; ?>

                <!--  BEGIN CONTENT AREA  -->
                <div id="content" class="main-content <?php echo e(Request::routeIs('blank') ? 'ms-0 mt-0' : ''); ?>">

                    <?php if(isset($scrollspy)): ?>
                        
                        <?php if($scrollspy): ?>
                            <div class="container">
                                <div class="container">                
                                    <div class="middle-content container-xxl p-0">
            
                                        <!--  BEGIN BREADCRUMBS  -->
                                        
                                        <!--  END BREADCRUMBS  -->
                                        
                                        <!--  BEGIN CONTENT  -->
                                        <?php echo $__env->yieldContent('content'); ?>
                                        <!--  END CONTENT  -->

                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="layout-px-spacing">
                                <div class="middle-content <?php echo e(Request::routeIs('boxed') ? 'container-xxl' : ''); ?> p-0">
                                    <?php if(!Request::routeIs('blank')): ?>
                                        <!--  BEGIN BREADCRUMBS  -->
                                        
                                        <!--  END BREADCRUMBS  -->
                                    <?php endif; ?>
                                                            
                                    <!--  BEGIN CONTENT  -->
                                    <?php echo $__env->yieldContent('content'); ?>
                                    <!--  END CONTENT  -->
                                </div>

                            </div>
                        <?php endif; ?>

                    <?php endif; ?>
                    
                    <?php if(!Request::routeIs('blank')): ?>
                        <!--  BEGIN FOOTER  -->
                        <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <!--  END FOOTER  -->
                    <?php endif; ?>
                </div>
                <!--  END CONTENT AREA  -->

            </div>
            <!-- END MAIN CONTAINER -->
            
        <?php endif; ?>
        
    <?php endif; ?>

    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
    <script src="<?php echo e(asset('plugins/src/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/src/perfect-scrollbar/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/src/mousetrap/mousetrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/src/waves/waves.min.js')); ?>"></script>
    <script src="<?php echo e(asset('plugins/src/highlight/highlight.pack.js')); ?>"></script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/layouts/semi-dark-menu/app.js']); ?>
    
    <?php if(isset($scrollspy)): ?>
        <?php if($scrollspy): ?>
            <?php echo app('Illuminate\Foundation\Vite')(['resources/js/scrollspyNav.js']); ?>
        <?php endif; ?>
    <?php endif; ?>
    
    <!-- END GLOBAL MANDATORY SCRIPTS -->

    <!-- BEGIN PAGE LEVEL PLUGINS/CUSTOM SCRIPTS -->
    <?php echo $__env->yieldContent('scripts'); ?>
    <!-- BEGIN PAGE LEVEL PLUGINS/CUSTOM SCRIPTS -->

</body>
</html><?php /**PATH D:\Work Station\cork-v3.9.0\laravel\semi-dark-menu\resources\views/layouts/app.blade.php ENDPATH**/ ?>